"""
Creates a flower made of repeated polygonal petals.

Tweaking `sides`, `petals`, or the circle radius changes the pattern.
"""

import turtle


screen = turtle.Screen()
screen.setup(width=600, height=600)
screen.title("Python Turtle: Polygon Flower")
screen.bgcolor("#1e1e2f")

pen = turtle.Turtle()
pen.speed("fastest")
pen.pensize(2)
pen.color("#ff9f1c")

sides = 6
petals = 12
radius = 80
exterior_angle = 360 / sides

for _ in range(petals):
    for _ in range(sides):
        pen.circle(radius, extent=60)
        pen.left(180 - exterior_angle)
    pen.right(360 / petals)  # rotate before drawing the next petal

screen.mainloop()

